<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User; // استيراد مودل المستخدم
use Illuminate\Http\Request;

class UserController extends Controller
{
    /**
     * عرض قائمة بكل المستخدمين مع إمكانية البحث.
     */
    public function index(Request $request)
    {
        $query = User::query();

        // البحث بالاسم أو البريد الإلكتروني
        if ($request->filled('search')) {
            $searchTerm = $request->search;
            $query->where(function ($q) use ($searchTerm) {
                $q->where('name', 'like', "%{$searchTerm}%")
                  ->orWhere('email', 'like', "%{$searchTerm}%");
            });
        }

        $users = $query->latest()->paginate(20);

        return view('admin.users.index', compact('users'));
    }

    /**
     * عرض تفاصيل مستخدم محدد.
     */
    public function show(User $user)
    {
        // جلب آخر 10 جلسات لعب لهذا المستخدم
        $user->load(['gameSessions' => function ($query) {
            $query->with('game')->latest()->take(10);
        }]);
        
        return view('admin.users.show', compact('user'));
    }

    /**
     * تفعيل أو حظر حساب مستخدم.
     */
    public function toggleStatus(User $user)
    {
        // is_active هو اسم العمود الافتراضي الذي سنضيفه
        $user->update(['is_active' => !$user->is_active]);

        $status = $user->is_active ? 'تفعيل' : 'حظر';
        
        return back()->with('success', "تم {$status} حساب المستخدم بنجاح.");
    }
}