<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Package; // استيراد مودل الباقات

class PackageController extends Controller
{
    /**
     * إرجاع قائمة بالباقات الفعالة.
     */
    public function index()
    {
        try {
            // جلب كل الباقات التي حالتها "فعّالة" فقط
            $packages = Package::where('is_active', true)
                                ->with('questionCategory:id,name') // لجلب اسم الفئة التي تفتحها الباقة
                                ->latest()
                                ->get();
            
            return response()->json([
                'success' => true,
                'data' => [
                    'packages' => $packages
                ]
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'حدث خطأ في جلب الباقات',
                'error' => $e->getMessage()
            ], 500);
        }
    }
}