<?php

namespace App\Http\Controllers;

use App\Models\Game;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class FavoriteController extends Controller
{
    // جلب كل الألعاب المفضلة للمستخدم الحالي
    public function index()
    {
        $favorites = Auth::user()->favorites()->get();
        return response()->json(['success' => true, 'data' => $favorites]);
    }

    // إضافة لعبة إلى المفضلة
    public function store(Game $game)
    {
        Auth::user()->favorites()->syncWithoutDetaching([$game->id]);
        return response()->json(['success' => true, 'message' => 'Game added to favorites.']);
    }

    // إزالة لعبة من المفضلة
    public function destroy(Game $game)
    {
        Auth::user()->favorites()->detach($game->id);
        return response()->json(['success' => true, 'message' => 'Game removed from favorites.']);
    }
}