<?php

namespace App\Http\Controllers;

use App\Models\Package;
use Illuminate\Http\Request;

class PackageController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try {
            // جلب كل الباقات مع اسم الفئة التي تفتحها كل باقة
            $packages = Package::with('questionCategory:id,name')
                                ->latest()
                                ->get();

            return response()->json([
                'success' => true,
                'data' => [
                    'packages' => $packages
                ]
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'حدث خطأ في جلب الباقات',
                'error' => $e->getMessage()
            ], 500);
        }
    }
}