<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
      Schema::create('games', function (Blueprint $table) {
        $table->id();
        $table->string('name');
        $table->text('description');
        $table->string('image_path')->nullable(); // ✅ أضف هذا السطر هنا
        $table->string('type');
        $table->integer('max_questions')->default(10);
        $table->string('difficulty_level')->default('easy');
        $table->string('icon')->default('gamepad');
        $table->string('color')->default('#ffffff');
        $table->boolean('is_active')->default(true);
        $table->timestamps();
    });
    }
    public function down(): void {
        Schema::dropIfExists('games');
    }
};

