<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('questions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('question_category_id')->constrained('question_categories')->onDelete('cascade');
            $table->text('question_text');
            
            // ✅✅✅ التعديل الأهم ✅✅✅
            // الآن سيخزن الخيار مع النقاط الخاصة به
            // مثال: [{"option": "المنزل", "points": 5}, {"option": "الخروج", "points": 10}]
            $table->json('options')->nullable(); 

            $table->string('correct_answer')->nullable(); // سنتركه للعبة الأولى
            $table->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('questions');
    }
};

