<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\Admin;

class AdminSeeder extends Seeder
{
    public function run(): void
    {
        // حذف البيانات القديمة
        Admin::truncate();

        // إنشاء مدير افتراضي
        Admin::create([
            'name' => 'مدير التطبيق',
            'email' => 'admin@couples-app.com',
            'password' => Hash::make('admin123456'),
            'role' => 'super_admin',
            'is_active' => true,
        ]);

        // يمكنك إضافة مديرين آخرين
        Admin::create([
            'name' => 'محمد الإدارة',
            'email' => 'mohammed@couples-app.com',
            'password' => Hash::make('password123'),
            'role' => 'admin',
            'is_active' => true,
        ]);

        Admin::create([
            'name' => 'سارة المحتوى',
            'email' => 'sara@couples-app.com',
            'password' => Hash::make('password123'),
            'role' => 'admin',
            'is_active' => true,
        ]);
    }
}