<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Game;

class GameSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // تم حذف أمر التفريغ من هنا

        Game::create([
            'name' => 'ماذا يحب شريكك؟',
            'description' => 'اختبر مدى معرفتك بشريك حياتك من خلال أسئلة ممتعة',
            'type' => 'guess_partner',
            'max_questions' => 10,
            'color' => '#E91E63',
            'icon' => 'favorite_border',
            'is_active' => true,
        ]);

        Game::create([
            'name' => 'اختبار التوافق',
            'description' => 'اكتشفا نسبة التوافق بينكما من خلال أسئلة شخصية',
            'type' => 'compatibility',
            'max_questions' => 8,
            'color' => '#9C27B0',
            'icon' => 'favorite',
            'is_active' => true,
        ]);

        Game::create([
            'name' => 'لعبة إكس-أو',
            'description' => 'لعبة كلاسيكية من الأسرع في تكوين صف؟',
            'type' => 'tic_tac_toe',
            'max_questions' => 0,
            'difficulty_level' => 'easy',
            'icon' => 'grid_on',
            'color' => '#4CAF50',
            'is_active' => true,
        ]);
    }
}