<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class QuestionSeeder extends Seeder
{
    public function run(): void
    {
        // حذف البيانات القديمة
        DB::table('questions')->delete();
        DB::table('question_categories')->delete();

        // --- الفئة الأولى: أسئلة عامة (للعبة "ماذا يحب شريكك؟") ---
        $general_cat_id = DB::table('question_categories')->insertGetId([
            'name' => 'أسئلة عامة',
            'description' => 'أسئلة متنوعة عن الحياة اليومية',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('questions')->insert([
            [
                'question_text' => 'ما هو اللون المفضل لشريكك؟',
                'question_category_id' => $general_cat_id,
                'options' => json_encode([
                    ["option" => "أحمر"],
                    ["option" => "أزرق"],
                    ["option" => "أخضر"],
                    ["option" => "أسود"],
                    ["option" => "أبيض"]
                ]),
                'correct_answer' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'question_text' => 'ما هي الوجهة التي يحلم شريكك بالسفر إليها؟',
                'question_category_id' => $general_cat_id,
                'options' => json_encode([
                    ["option" => "باريس"],
                    ["option" => "طوكيو"],
                    ["option" => "مصر"],
                    ["option" => "تركيا"],
                    ["option" => "المالديف"]
                ]),
                'correct_answer' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'question_text' => 'ما هو الطعام المفضل لشريكك؟',
                'question_category_id' => $general_cat_id,
                'options' => json_encode([
                    ["option" => "البيتزا"],
                    ["option" => "المعكرونة"],
                    ["option" => "الكباب"],
                    ["option" => "السوشي"],
                    ["option" => "البرجر"]
                ]),
                'correct_answer' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'question_text' => 'ما هو فيلم شريكك المفضل؟',
                'question_category_id' => $general_cat_id,
                'options' => json_encode([
                    ["option" => "الأكشن"],
                    ["option" => "الرومانسي"],
                    ["option" => "الكوميدي"],
                    ["option" => "الرعب"],
                    ["option" => "الخيال العلمي"]
                ]),
                'correct_answer' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
        ]);

        // --- الفئة الثانية: أسئلة التوافق ---
        $compat_cat_id = DB::table('question_categories')->insertGetId([
            'name' => 'أسئلة التوافق',
            'description' => 'أسئلة لحساب نسبة التوافق بين الزوجين',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('questions')->insert([
            [
                'question_text' => 'هل تفضل قضاء ليلة هادئة في المنزل أم الخروج للسهر؟',
                'question_category_id' => $compat_cat_id,
                'options' => json_encode([
                    ["option" => "أفضل المنزل بالتأكيد", "points" => 5],
                    ["option" => "أحب الخروج أحياناً", "points" => 10],
                    ["option" => "أفضل الخروج دائماً", "points" => 15]
                ]),
                'correct_answer' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'question_text' => 'ما هي أولويتك في الحياة؟',
                'question_category_id' => $compat_cat_id,
                'options' => json_encode([
                    ["option" => "العائلة", "points" => 5],
                    ["option" => "العمل والنجاح", "points" => 10],
                    ["option" => "السفر والمغامرات", "points" => 15]
                ]),
                'correct_answer' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'question_text' => 'كيف تحب قضاء عطلة نهاية الأسبوع؟',
                'question_category_id' => $compat_cat_id,
                'options' => json_encode([
                    ["option" => "النوم والاسترخاء", "points" => 5],
                    ["option" => "أنشطة رياضية", "points" => 10],
                    ["option" => "رحلات واستكشاف", "points" => 15]
                ]),
                'correct_answer' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'question_text' => 'ما هو أسلوبك في التعامل مع المشاكل؟',
                'question_category_id' => $compat_cat_id,
                'options' => json_encode([
                    ["option" => "أفضل الحديث المباشر", "points" => 15],
                    ["option" => "أحتاج وقت للتفكير", "points" => 10],
                    ["option" => "أتجنب المواجهة", "points" => 5]
                ]),
                'correct_answer' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'question_text' => 'ما هو مفهومك للرومانسية؟',
                'question_category_id' => $compat_cat_id,
                'options' => json_encode([
                    ["option" => "الهدايا والمفاجآت", "points" => 10],
                    ["option" => "قضاء وقت ممتع معاً", "points" => 15],
                    ["option" => "كلمات الحب والاهتمام", "points" => 5]
                ]),
                'correct_answer' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
        ]);
    }
}