@extends('admin.layouts.app')

@section('title', 'تعديل صورة اللعبة')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-1">تعديل صورة اللعبة: {{ $game->name }}</h1>
        <a href="{{ route('admin.games.index') }}" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>
            العودة
        </a>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.games.update', $game->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                @if($game->image_path)
                <div class="mb-3">
                    <label class="form-label d-block">الصورة الحالية:</label>
                    <img src="{{ asset('storage/' . $game->image_path) }}" alt="{{ $game->name }}" class="img-thumbnail" style="max-width: 200px;">
                </div>
                @endif

                <div class="mb-3">
                    <label for="image" class="form-label">{{ $game->image_path ? 'اختر صورة جديدة لتغييرها' : 'اختر صورة للعبة' }} <span class="text-danger">*</span></label>
                    <input class="form-control @error('image') is-invalid @enderror" type="file" id="image" name="image" required>
                    <small class="form-text text-muted">يفضل أن تكون الأبعاد متناسقة.</small>
                    @error('image')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>
                        حفظ الصورة
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection