@extends('admin.layouts.app')

@section('title', 'إدارة الألعاب')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">إدارة الألعاب</h1>
            <p class="text-muted mb-0">تعديل الصور والأيقونات الخاصة بالألعاب الأساسية</p>
        </div>
    </div>

    <div class="card">
        <div class="card-header bg-white border-bottom">
            <h5 class="card-title mb-0">
                <i class="fas fa-gamepad text-primary me-2"></i>
                قائمة الألعاب
            </h5>
        </div>
        
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th width="10%">#</th>
                            <th width="15%">الصورة الحالية</th>
                            <th width="50%">اسم اللعبة</th>
                            <th width="25%">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($games as $game)
                            <tr>
                                <td>{{ $game->id }}</td>
                                <td>
                                    @if($game->image_path)
                                        <img src="{{ asset('storage/' . $game->image_path) }}" alt="{{ $game->name }}" class="img-thumbnail" width="80">
                                    @else
                                        <span class="badge bg-secondary">لا توجد صورة</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="fw-medium">{{ $game->name }}</div>
                                    <small class="text-muted">{{ $game->description }}</small>
                                </td>
                                <td>
                                    <a href="{{ route('admin.games.edit', $game->id) }}" class="btn btn-sm btn-outline-warning">
                                        <i class="fas fa-edit me-1"></i>
                                        تعديل الصورة
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center py-4">لا توجد ألعاب في قاعدة البيانات.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection