@extends('admin.layouts.app')

@section('title', 'تعديل السؤال')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">تعديل السؤال</h1>
            <p class="text-muted mb-0">تعديل تفاصيل السؤال وخياراته</p>
        </div>
        <a href="{{ route('admin.questions.index') }}" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>
            العودة لقائمة الأسئلة
        </a>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.questions.update', $question->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="mb-3">
                    <label for="question_text" class="form-label">نص السؤال <span class="text-danger">*</span></label>
                    <textarea class="form-control @error('question_text') is-invalid @enderror" id="question_text" name="question_text" rows="3" required>{{ old('question_text', $question->question_text) }}</textarea>
                    @error('question_text')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="question_category_id" class="form-label">الفئة <span class="text-danger">*</span></label>
                        <select class="form-select @error('question_category_id') is-invalid @enderror" id="question_category_id" name="question_category_id" required>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}" {{ old('question_category_id', $question->question_category_id) == $category->id ? 'selected' : '' }}>
                                    {{ $category->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('question_category_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="question_type" class="form-label">نوع السؤال <span class="text-danger">*</span></label>
                        <select class="form-select" id="question_type" name="question_type" required>
                            <option value="multiple_choice" {{ (old('question_type') ?? ($question->options ? 'multiple_choice' : 'text_input')) == 'multiple_choice' ? 'selected' : '' }}>
                                اختيار متعدد (إجابات محددة)
                            </option>
                            <option value="text_input" {{ (old('question_type') ?? ($question->options ? 'multiple_choice' : 'text_input')) == 'text_input' ? 'selected' : '' }}>
                                نص مفتوح (لا يحتاج خيارات)
                            </option>
                        </select>
                    </div>
                </div>

                <div id="options_section" class="mb-3 border p-3 rounded bg-light" style="display: none;">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="mb-0">الخيارات</h5>
                        <button type="button" id="add_option_btn" class="btn btn-sm btn-success">
                            <i class="fas fa-plus me-1"></i> إضافة خيار
                        </button>
                    </div>
                    
                    <div id="options_container">
                        @if(old('options', $options))
                            @foreach(old('options', $options) as $index => $option)
                                <div class="row align-items-center mb-2 option-row">
                                    <div class="col-md-7">
                                        <input type="text" name="options[{{ $index }}][option]" class="form-control" placeholder="نص الخيار" value="{{ $option['option'] ?? '' }}" required>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fas fa-star"></i></span>
                                            <input type="number" name="options[{{ $index }}][points]" class="form-control" placeholder="النقاط (اختياري)" value="{{ $option['points'] ?? '' }}">
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <button type="button" class="btn btn-sm btn-outline-danger remove-option-btn w-100">
                                            <i class="fas fa-trash"></i> حذف
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                     @error('options')
                        <div class="text-danger mt-2"><small>{{ $message }}</small></div>
                    @enderror
                </div>
                
                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>
                        حفظ التعديلات
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    const questionTypeSelect = document.getElementById('question_type');
    const optionsSection = document.getElementById('options_section');
    const addOptionBtn = document.getElementById('add_option_btn');
    const optionsContainer = document.getElementById('options_container');
    let optionIndex = {{ count(old('options', $options)) }};

    // دالة لإظهار/إخفاء قسم الخيارات
    function toggleOptionsSection() {
        if (questionTypeSelect.value === 'multiple_choice') {
            optionsSection.style.display = 'block';
        } else {
            optionsSection.style.display = 'none';
        }
    }

    // إضافة خيار جديد
    addOptionBtn.addEventListener('click', function () {
        optionIndex++;
        const newOptionRow = `
            <div class="row align-items-center mb-2 option-row">
                <div class="col-md-7">
                    <input type="text" name="options[${optionIndex}][option]" class="form-control" placeholder="نص الخيار" required>
                </div>
                <div class="col-md-3">
                    <div class="input-group">
                         <span class="input-group-text"><i class="fas fa-star"></i></span>
                        <input type="number" name="options[${optionIndex}][points]" class="form-control" placeholder="النقاط (اختياري)">
                    </div>
                </div>
                <div class="col-md-2">
                    <button type="button" class="btn btn-sm btn-outline-danger remove-option-btn w-100">
                        <i class="fas fa-trash"></i> حذف
                    </button>
                </div>
            </div>`;
        optionsContainer.insertAdjacentHTML('beforeend', newOptionRow);
    });

    // حذف خيار
    optionsContainer.addEventListener('click', function (e) {
        if (e.target && e.target.classList.contains('remove-option-btn')) {
            e.target.closest('.option-row').remove();
        }
    });

    // تفعيل عند تغيير نوع السؤال
    questionTypeSelect.addEventListener('change', toggleOptionsSection);

    // تفعيل عند تحميل الصفحة
    toggleOptionsSection();
});
</script>
@endpush