@extends('admin.layouts.app')

@section('title', 'إدارة الأسئلة')

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">إدارة الأسئلة</h1>
            <p class="text-muted mb-0">إضافة وتعديل وحذف أسئلة التطبيق</p>
        </div>
        <a href="{{ route('admin.questions.create') }}" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>
            إضافة سؤال جديد
        </a>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('admin.questions.index') }}" class="row g-3">
                <div class="col-md-4">
                    <label for="search" class="form-label">البحث في الأسئلة</label>
                    <input type="text" class="form-control" id="search" name="search" 
                           value="{{ request('search') }}" placeholder="ابحث في نص السؤال...">
                </div>
                <div class="col-md-4">
                    <label for="category" class="form-label">الفئة</label>
                    <select class="form-select" id="category" name="category">
                        <option value="">جميع الفئات</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" 
                                {{ request('category') == $category->id ? 'selected' : '' }}>
                                {{ $category->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-outline-primary me-2">
                        <i class="fas fa-search me-1"></i>
                        بحث
                    </button>
                    <a href="{{ route('admin.questions.index') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-times me-1"></i>
                        مسح
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Questions List -->
    <div class="card">
        <div class="card-header bg-white border-bottom">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-question-circle text-primary me-2"></i>
                    قائمة الأسئلة ({{ $questions->total() }})
                </h5>
                
                @if(request()->hasAny(['search', 'category']))
                    <span class="badge bg-info">
                        <i class="fas fa-filter me-1"></i>
                        مفلترة
                    </span>
                @endif
            </div>
        </div>
        
        <div class="card-body p-0">
            @if($questions->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th width="5%">#</th>
                                <th width="45%">نص السؤال</th>
                                <th width="15%">الفئة</th>
                                <th width="10%">نوع السؤال</th>
                                <th width="10%">عدد الخيارات</th>
                                <th width="10%">تاريخ الإنشاء</th>
                                <th width="15%">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($questions as $question)
                                <tr>
                                    <td>{{ $question->id }}</td>
                                    <td>
                                        <div class="fw-medium">
                                            {{ Str::limit($question->question_text, 80) }}
                                        </div>
                                    </td>
                                  <td>
                                        <span class="badge bg-secondary">
                                            {{ $question->category->name ?? 'غير محدد' }}
                                        </span>
                                    </td>
                                    <td>
                                        @php
                                            // ✅ إصلاح: التعامل مع options سواء كانت array أو JSON string
                                            $optionsData = $question->options;
                                            $hasOptions = false;
                                            $optionsCount = 0;
                                            
                                            if (!empty($optionsData)) {
                                                // إذا كانت string، حولها لـ array
                                                if (is_string($optionsData)) {
                                                    $decoded = json_decode($optionsData, true);
                                                    if (is_array($decoded)) {
                                                        $optionsData = $decoded;
                                                        $hasOptions = true;
                                                        $optionsCount = count($optionsData);
                                                    }
                                                } 
                                                // إذا كانت array بالفعل (بسبب cast في Model)
                                                elseif (is_array($optionsData)) {
                                                    $hasOptions = true;
                                                    $optionsCount = count($optionsData);
                                                }
                                            }
                                        @endphp
                                        
                                        <span class="badge {{ $hasOptions ? 'bg-success' : 'bg-warning' }}">
                                            {{ $hasOptions ? 'اختيار متعدد' : 'نص مفتوح' }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($hasOptions)
                                            <span class="text-primary fw-bold">{{ $optionsCount }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <small class="text-muted">
                                            {{ $question->created_at->format('Y/m/d') }}
                                        </small>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="{{ route('admin.questions.show', $question) }}" 
                                               class="btn btn-outline-info" title="عرض">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('admin.questions.edit', $question) }}" 
                                               class="btn btn-outline-warning" title="تعديل">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-outline-danger" 
                                                    onclick="deleteQuestion({{ $question->id }})" title="حذف">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                @if($questions->hasPages())
                    <div class="d-flex justify-content-center mt-4">
                        {{ $questions->withQueryString()->links() }}
                    </div>
                @endif
                
            @else
                <!-- Empty State -->
                <div class="text-center py-5">
                    <i class="fas fa-question-circle fa-4x text-muted mb-4 opacity-25"></i>
                    <h4 class="text-muted">لا توجد أسئلة</h4>
                    <p class="text-muted mb-4">
                        @if(request()->hasAny(['search', 'category']))
                            لم يتم العثور على أسئلة مطابقة لمعايير البحث
                        @else
                            ابدأ بإضافة أول سؤال للتطبيق
                        @endif
                    </p>
                    <a href="{{ route('admin.questions.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>
                        إضافة أول سؤال
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-exclamation-triangle text-warning me-2"></i>
                    تأكيد الحذف
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>هل أنت متأكد من حذف هذا السؤال؟</p>
                <p class="text-danger">
                    <small><i class="fas fa-info-circle me-1"></i>
                    لا يمكن التراجع عن هذا الإجراء</small>
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash me-1"></i>
                        حذف نهائياً
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function deleteQuestion(questionId) {
    const deleteForm = document.getElementById('deleteForm');
    deleteForm.action = `{{ route('admin.questions.index') }}/${questionId}`;
    
    const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
    deleteModal.show();
}
</script>
@endpush