@extends('admin.layouts.app')

@section('title', 'تفاصيل المستخدم')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-1">تفاصيل المستخدم: {{ $user->name }}</h1>
        <a href="{{ route('admin.users.index') }}" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>
            العودة لقائمة المستخدمين
        </a>
    </div>

    <div class="row">
        <div class="col-lg-4">
            <div class="card mb-4">
                <div class="card-body text-center">
                    <div class="avatar mx-auto mb-3">
                        <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center" style="width: 100px; height: 100px;">
                            <i class="fas fa-user fa-3x text-white"></i>
                        </div>
                    </div>
                    <h5 class="my-3">{{ $user->name }}</h5>
                    <p class="text-muted mb-1">{{ $user->email }}</p>
                    <p class="text-muted mb-4">تاريخ التسجيل: {{ $user->created_at->format('d M, Y') }}</p>
                    <form action="{{ route('admin.users.toggle-status', $user->id) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        @if($user->is_active)
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-ban me-2"></i> حظر الحساب
                            </button>
                        @else
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-check-circle me-2"></i> تفعيل الحساب
                            </button>
                        @endif
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">آخر جلسات اللعب</div>
                <div class="card-body">
                    @if($user->gameSessions->count() > 0)
                        <ul class="list-group list-group-flush">
                            @foreach($user->gameSessions as $session)
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong>{{ $session->game->name ?? 'لعبة محذوفة' }}</strong>
                                        <br>
                                        <small class="text-muted">النتيجة: {{ $session->score ?? 0 }} نقطة</small>
                                    </div>
                                    <span class="text-muted">{{ $session->created_at->diffForHumans() }}</span>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <p class="text-center text-muted">لم يقم هذا المستخدم بلعب أي لعبة بعد.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
