<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\QuestionController;
use App\Http\Controllers\Admin\QuestionCategoryController; // <-- قم باستيراد الـ Controller الجديد
use App\Http\Controllers\Admin\GameController;
use App\Http\Controllers\Admin\PackageController; // <-- قم باستيراد الـ Controller الجديد
use App\Http\Controllers\Admin\UserController;

// مسارات غير محمية (تسجيل الدخول)
Route::get('/login', [AdminController::class, 'showLoginForm'])->name('admin.login');
Route::post('/login', [AdminController::class, 'login'])->name('admin.login.post');

// مسارات محمية (تحتاج تسجيل دخول)
Route::middleware(['auth:admin'])->group(function () {
    
    // Dashboard & Auth
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
    Route::post('/logout', [AdminController::class, 'logout'])->name('admin.logout');
    

    Route::get('/profile', [AdminController::class, 'showProfileForm'])->name('admin.profile.show');
    Route::put('/profile', [AdminController::class, 'updateProfile'])->name('admin.profile.update');
    // ✅ إدارة الباقات المدفوعة
    Route::resource('packages', PackageController::class)->names('admin.packages');

      // ✅ إدارة فئات الأسئلة
    Route::resource('question-categories', QuestionCategoryController::class)
         ->names('admin.question-categories'); // <-- أضف هذا السطر
         
    // ✅ إدارة الأسئلة - مسارات حقيقية
    Route::prefix('questions')->name('admin.questions.')->group(function () {
        Route::get('/', [QuestionController::class, 'index'])->name('index');
        Route::get('/create', [QuestionController::class, 'create'])->name('create');
        Route::post('/', [QuestionController::class, 'store'])->name('store');
        Route::get('/{question}', [QuestionController::class, 'show'])->name('show');
        Route::get('/{question}/edit', [QuestionController::class, 'edit'])->name('edit');
        Route::put('/{question}', [QuestionController::class, 'update'])->name('update');
        Route::delete('/{question}', [QuestionController::class, 'destroy'])->name('destroy');
        
        // AJAX route لإنشاء فئة جديدة
        Route::post('/categories/create', [QuestionController::class, 'createCategory'])->name('categories.create');
    });
    
   // إدارة المديرين
Route::prefix('admins')->name('admin.admins.')->group(function () {
    Route::get('/', [AdminController::class, 'admins'])->name('index');
    Route::get('/create', [AdminController::class, 'createAdmin'])->name('create');
    Route::post('/', [AdminController::class, 'storeAdmin'])->name('store');
    Route::patch('/{admin}/toggle-status', [AdminController::class, 'toggleAdminStatus'])->name('toggle-status');

    // ✅ أضف المسارات الجديدة هنا
    Route::get('/{admin}/edit', [AdminController::class, 'editAdmin'])->name('edit');
    Route::put('/{admin}', [AdminController::class, 'updateAdmin'])->name('update');
    Route::delete('/{admin}', [AdminController::class, 'destroyAdmin'])->name('destroy');
});
    
// ✅ إدارة المستخدمين
Route::prefix('users')->name('admin.users.')->group(function () {
    Route::get('/', [UserController::class, 'index'])->name('index');
    Route::get('/{user}', [UserController::class, 'show'])->name('show');
    Route::patch('/{user}/toggle-status', [UserController::class, 'toggleStatus'])->name('toggle-status');
});

    // باقي المسارات المؤقتة
    
    Route::get('/analytics', function() {
        return redirect()->route('admin.dashboard')->with('info', 'قريباً: الإحصائيات');
    })->name('admin.analytics.index');
    
   // ✅ إدارة صور الألعاب (عرض وتعديل فقط)
Route::get('/games', [GameController::class, 'index'])->name('admin.games.index');
Route::get('/games/{game}/edit', [GameController::class, 'edit'])->name('admin.games.edit');
Route::put('/games/{game}', [GameController::class, 'update'])->name('admin.games.update');
    
});