<?php

use Illuminate\Support\Facades\Broadcast;

Broadcast::channel('App.Models.User.{id}', function ($user, $id) {
    return (int) $user->id === (int) $id;
});

// القناة الخاصة بجلسات الألعاب
Broadcast::channel('game-session.{sessionId}', function ($user, $sessionId) {
    \Log::info("🔐 Channel auth attempt for game-session.{$sessionId} by user {$user->id}");
    
    $session = \App\Models\GameSession::find($sessionId);
    
    if (!$session) {
        \Log::warning("❌ Session {$sessionId} not found for channel auth");
        return false;
    }
    
    $isAuthorized = $session->user_id === $user->id || $session->partner_id === $user->id;
    
    \Log::info("🔐 Channel auth for session {$sessionId}: " . ($isAuthorized ? 'AUTHORIZED' : 'DENIED') . 
               " (user: {$user->id}, session owner: {$session->user_id}, partner: {$session->partner_id})");
    
    return $isAuthorized;
});