<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Broadcast;
use App\Http\Controllers\ImageController; // أضف هذا السطر

Route::get('/', function () {
    return view('welcome');
});
Route::prefix('admin')->group(base_path('routes/admin.php'));
// ✅ إضافة login route
Route::get('/login', function () {
    return response()->json(['message' => 'Unauthenticated'], 401);
})->name('login');

// ✅ إضافة broadcasting auth routes
Broadcast::routes(['middleware' => ['auth:sanctum']]);

// ✅✅✅ أضف هذا الرابط في نهاية الملف ✅✅✅
Route::get('storage/{path}', [ImageController::class, 'show'])->where('path', '.*');