

<?php $__env->startSection('title', 'إدارة الألعاب'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">إدارة الألعاب</h1>
            <p class="text-muted mb-0">تعديل الصور والأيقونات الخاصة بالألعاب الأساسية</p>
        </div>
    </div>

    <div class="card">
        <div class="card-header bg-white border-bottom">
            <h5 class="card-title mb-0">
                <i class="fas fa-gamepad text-primary me-2"></i>
                قائمة الألعاب
            </h5>
        </div>
        
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th width="10%">#</th>
                            <th width="15%">الصورة الحالية</th>
                            <th width="50%">اسم اللعبة</th>
                            <th width="25%">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $games; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $game): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($game->id); ?></td>
                                <td>
                                    <?php if($game->image_path): ?>
                                        <img src="<?php echo e(asset('storage/' . $game->image_path)); ?>" alt="<?php echo e($game->name); ?>" class="img-thumbnail" width="80">
                                    <?php else: ?>
                                        <span class="badge bg-secondary">لا توجد صورة</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="fw-medium"><?php echo e($game->name); ?></div>
                                    <small class="text-muted"><?php echo e($game->description); ?></small>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.games.edit', $game->id)); ?>" class="btn btn-sm btn-outline-warning">
                                        <i class="fas fa-edit me-1"></i>
                                        تعديل الصورة
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="text-center py-4">لا توجد ألعاب في قاعدة البيانات.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\couples_app_api\resources\views\admin\games\index.blade.php ENDPATH**/ ?>