

<?php $__env->startSection('title', 'تفاصيل المستخدم'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-1">تفاصيل المستخدم: <?php echo e($user->name); ?></h1>
        <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>
            العودة لقائمة المستخدمين
        </a>
    </div>

    <div class="row">
        <div class="col-lg-4">
            <div class="card mb-4">
                <div class="card-body text-center">
                    <div class="avatar mx-auto mb-3">
                        <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center" style="width: 100px; height: 100px;">
                            <i class="fas fa-user fa-3x text-white"></i>
                        </div>
                    </div>
                    <h5 class="my-3"><?php echo e($user->name); ?></h5>
                    <p class="text-muted mb-1"><?php echo e($user->email); ?></p>
                    <p class="text-muted mb-4">تاريخ التسجيل: <?php echo e($user->created_at->format('d M, Y')); ?></p>
                    <form action="<?php echo e(route('admin.users.toggle-status', $user->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        <?php if($user->is_active): ?>
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-ban me-2"></i> حظر الحساب
                            </button>
                        <?php else: ?>
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-check-circle me-2"></i> تفعيل الحساب
                            </button>
                        <?php endif; ?>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">آخر جلسات اللعب</div>
                <div class="card-body">
                    <?php if($user->gameSessions->count() > 0): ?>
                        <ul class="list-group list-group-flush">
                            <?php $__currentLoopData = $user->gameSessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong><?php echo e($session->game->name ?? 'لعبة محذوفة'); ?></strong>
                                        <br>
                                        <small class="text-muted">النتيجة: <?php echo e($session->score ?? 0); ?> نقطة</small>
                                    </div>
                                    <span class="text-muted"><?php echo e($session->created_at->diffForHumans()); ?></span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php else: ?>
                        <p class="text-center text-muted">لم يقم هذا المستخدم بلعب أي لعبة بعد.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\couples_app_api\resources\views/admin/users/show.blade.php ENDPATH**/ ?>