

<?php $__env->startSection('title', 'تعديل السؤال'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">تعديل السؤال</h1>
            <p class="text-muted mb-0">تعديل تفاصيل السؤال وخياراته</p>
        </div>
        <a href="<?php echo e(route('admin.questions.index')); ?>" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>
            العودة لقائمة الأسئلة
        </a>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="<?php echo e(route('admin.questions.update', $question->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="mb-3">
                    <label for="question_text" class="form-label">نص السؤال <span class="text-danger">*</span></label>
                    <textarea class="form-control <?php $__errorArgs = ['question_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="question_text" name="question_text" rows="3" required><?php echo e(old('question_text', $question->question_text)); ?></textarea>
                    <?php $__errorArgs = ['question_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="question_category_id" class="form-label">الفئة <span class="text-danger">*</span></label>
                        <select class="form-select <?php $__errorArgs = ['question_category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="question_category_id" name="question_category_id" required>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>" <?php echo e(old('question_category_id', $question->question_category_id) == $category->id ? 'selected' : ''); ?>>
                                    <?php echo e($category->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['question_category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="question_type" class="form-label">نوع السؤال <span class="text-danger">*</span></label>
                        <select class="form-select" id="question_type" name="question_type" required>
                            <option value="multiple_choice" <?php echo e((old('question_type') ?? ($question->options ? 'multiple_choice' : 'text_input')) == 'multiple_choice' ? 'selected' : ''); ?>>
                                اختيار متعدد (إجابات محددة)
                            </option>
                            <option value="text_input" <?php echo e((old('question_type') ?? ($question->options ? 'multiple_choice' : 'text_input')) == 'text_input' ? 'selected' : ''); ?>>
                                نص مفتوح (لا يحتاج خيارات)
                            </option>
                        </select>
                    </div>
                </div>

                <div id="options_section" class="mb-3 border p-3 rounded bg-light" style="display: none;">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="mb-0">الخيارات</h5>
                        <button type="button" id="add_option_btn" class="btn btn-sm btn-success">
                            <i class="fas fa-plus me-1"></i> إضافة خيار
                        </button>
                    </div>
                    
                    <div id="options_container">
                        <?php if(old('options', $options)): ?>
                            <?php $__currentLoopData = old('options', $options); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="row align-items-center mb-2 option-row">
                                    <div class="col-md-7">
                                        <input type="text" name="options[<?php echo e($index); ?>][option]" class="form-control" placeholder="نص الخيار" value="<?php echo e($option['option'] ?? ''); ?>" required>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fas fa-star"></i></span>
                                            <input type="number" name="options[<?php echo e($index); ?>][points]" class="form-control" placeholder="النقاط (اختياري)" value="<?php echo e($option['points'] ?? ''); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <button type="button" class="btn btn-sm btn-outline-danger remove-option-btn w-100">
                                            <i class="fas fa-trash"></i> حذف
                                        </button>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                     <?php $__errorArgs = ['options'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-2"><small><?php echo e($message); ?></small></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>
                        حفظ التعديلات
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const questionTypeSelect = document.getElementById('question_type');
    const optionsSection = document.getElementById('options_section');
    const addOptionBtn = document.getElementById('add_option_btn');
    const optionsContainer = document.getElementById('options_container');
    let optionIndex = <?php echo e(count(old('options', $options))); ?>;

    // دالة لإظهار/إخفاء قسم الخيارات
    function toggleOptionsSection() {
        if (questionTypeSelect.value === 'multiple_choice') {
            optionsSection.style.display = 'block';
        } else {
            optionsSection.style.display = 'none';
        }
    }

    // إضافة خيار جديد
    addOptionBtn.addEventListener('click', function () {
        optionIndex++;
        const newOptionRow = `
            <div class="row align-items-center mb-2 option-row">
                <div class="col-md-7">
                    <input type="text" name="options[${optionIndex}][option]" class="form-control" placeholder="نص الخيار" required>
                </div>
                <div class="col-md-3">
                    <div class="input-group">
                         <span class="input-group-text"><i class="fas fa-star"></i></span>
                        <input type="number" name="options[${optionIndex}][points]" class="form-control" placeholder="النقاط (اختياري)">
                    </div>
                </div>
                <div class="col-md-2">
                    <button type="button" class="btn btn-sm btn-outline-danger remove-option-btn w-100">
                        <i class="fas fa-trash"></i> حذف
                    </button>
                </div>
            </div>`;
        optionsContainer.insertAdjacentHTML('beforeend', newOptionRow);
    });

    // حذف خيار
    optionsContainer.addEventListener('click', function (e) {
        if (e.target && e.target.classList.contains('remove-option-btn')) {
            e.target.closest('.option-row').remove();
        }
    });

    // تفعيل عند تغيير نوع السؤال
    questionTypeSelect.addEventListener('change', toggleOptionsSection);

    // تفعيل عند تحميل الصفحة
    toggleOptionsSection();
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\couples_app_api\resources\views\admin\questions\edit.blade.php ENDPATH**/ ?>